
# KillSOPA

This is JavaScript code to make it simple to add an anti-SOPA splash dialog to
your web site.

The dialog sets a cookie when dismissed, to ensure that users are not bothered
by it repeatedly.

The JavaScript code works on IE7+, Chrome and Firefox. It should work on Opera
and Safari, but I haven't tested that yet.

The splash looks uglier in IE7, because of IE7's poor CSS support, but I'm not
very motivated to fix that.

Once the user has seen and dismissed the splash dialog and the cookie has been
set, the total impact on page load is 1221 bytes of minimized JavaScript and
one constructor call. The CSS, HTML, image and font aren't loaded unless the
dialog needs to be shown.

When showing the dialog, the size of the image (46kB) easily dwarfs everything
else. (The font is about 14kB.)

## Instructions

Place the following files in a directory on a web host:

    killsopa-min.js killsopa-min.css alert-overlay.png seized.png

Note the base URL for the files, e.g. http://www.example.com/sopasplash/

Add the following to your web pages:

    <script type='text/javascript' src='http://www.example.com/sopasplash/killsopa-min.js'></script>
    <script type='text/javascript'>
      var whatever = new KillSOPA('http://www.example.com/sopasplash/');
    </script>

That's it.

The splash dialog files do not need to be hosted on the same server as the page
which will show the splash dialog.

## Optional extras

If you want to override the URL people are taken to when they click the 'more
information' button, pass it in as a second argument to the constructor. e.g.

    <script type='text/javascript'>
      var whatever = new KillSOPA('http://www.example.com/sopasplash/',
        'http://www.killsopa.org/');
    </script>

The extra files in the repository are as follows:

| File          | Contents                           |
|---------------|------------------------------------|
| killsopa.css  | The CSS before compression.        |
| killsopa.js   | The JavaScript before compression. |
| killsopa.html | The HTML for the splash screen.    |

## Improvements

If you want to submit improvements, please bear the following in mind:

 * No frameworks -- The code should not require (say) jQuery.

 * No compilers -- The code should be JavaScript and CSS, and not something
     else that has to be compiled into JavaScript and CSS.

 * Keep it small -- Minimize the impact on page load times.

 * Keep it fluid -- Don't assume any particular browser window size.

## Disclaimer

Opinions expressed in this project are mine, and not those of my employer.

## License

Code is released under the GNU Public License, version 3.0 or later.

This does not mean that your web site content or code needs to be released
under any kind of public license.

## Credits

Web font served by Google. CSS button code from [ZURBlog](http://www.zurb.com/article/266/super-awesome-buttons-with-css3-and-rgba).

