<?php
if (IN_serendipity !== true) {
	die ("Don't hack!");
}

// Probe for a language include with constants. Still include defines later on, if some constants were missing
$probelang = dirname (__FILE__) . '/' . $serendipity['charset'] . 'lang_' . $serendipity['lang'] . '.inc.php';
if (file_exists ($probelang)) {
	include $probelang;
}

include dirname (__FILE__) . '/lang_en.inc.php';

class serendipity_event_stopsopa extends serendipity_event {
	var $title = PLUGIN_EVENT_STOPSOPA_NAME;
	
	function introspect(&$propbag) {
		global $serendipity;
		
		$propbag->add ('name', PLUGIN_EVENT_STOPSOPA_NAME);
		$propbag->add ('description', PLUGIN_EVENT_STOPSOPA_DESC);
		$propbag->add ('stackable', false);
		$propbag->add ('author', '<a href="http://blog.godshell.com/" target="_blank">Jason Frisvold</a>');
		$propbag->add ('version', '1.0.0');
		$propbag->add ('requirements', array ('serendipity' => '0.8', 'smarty' => '2.6.7', 'php' => '4.1.0' ));
		$propbag->add ('groups', array ('STATISTICS' ));
		$propbag->add ('cachable_events', array ('frontend_display' => true ));
		$propbag->add ('event_hooks', array ('frontend_footer' => true, 'frontend_display' => true ));
		
		$conf_array = array ();
		$conf_array[] = 'stopsopa_website';
		
		$propbag->add ('configuration', $conf_array);
	}
	
	function introspect_config_item($name, &$propbag) {
		switch ($name) {
			case 'stopsopa_website' :
				$propbag->add ('type', 'string');
				$propbag->add ('name', PLUGIN_EVENT_STOPSOPA_WEBSITE);
				$propbag->add ('description', PLUGIN_EVENT_STOPSOPA_WEBSITE_DESC);
				$propbag->add ('default', '');
				break;
		}
		return true;
	}
	
	function generate_content(&$title) {
		$title = $this->get_config ('title');
	}
	
	function install() {
		serendipity_plugin_api::hook_event ('backend_cache_entries', $this->title);
	}
	
	function uninstall() {
		serendipity_plugin_api::hook_event ('backend_cache_purge', $this->title);
		serendipity_plugin_api::hook_event ('backend_cache_entries', $this->title);
	}
	
	function trim_value(&$value) {
		$value = trim ($value);
	}
	
	function in_array_loop($array1, $array2) {
		if (is_array ($array1)) {
			foreach ( $array1 as $array ) {
				if (in_array ($array, $array2)) {
					return true;
				}
			}
		}
		return false;
	}
	
	function event_hook($event, &$bag, &$eventData, $addData = null) {
		global $serendipity;
		static $usergroup = false;
		$hooks = &$bag->get ('event_hooks');
		
		if (isset ($hooks[$event])) {
			switch ($event) {
				case 'frontend_footer' :
               $sopalocation = $serendipity['baseURL'] . 'plugins/serendipity_event_stopsopa/sopasplash';
					echo '
<!-- STOPSOPA -->
<script type="text/javascript" src="' . $sopalocation . '/killsopa.js"></script>
<script type="text/javascript">';

               if ($this->get_config('stopsopa_website') != '') {
                  echo '
   var whatever = new KillSOPA("' . $sopalocation . '/","' . $this->get_config ('stopsopa_website') . '");';
               } else {
                  echo '
   var whatever = new KillSOPA("' . $sopalocation . '/");';
               }

               echo '
</script>
<!-- End STOPSOPA Tag -->';
					
					return true;
					break;
				
				default :
					return false;
			}
		} else {
			return false;
		}
	}
}

